IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Rpt_CD_ES_Clientes_Cantidades') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION CF_Rpt_CD_ES_Clientes_Cantidades
END
GO

CREATE FUNCTION [dbo].[CF_Rpt_CD_ES_Clientes_Cantidades](@pId_Controlador SMALLINT, @pResultado CHAR(1), @pTipo CHAR(1), @pFecha_Desde DATETIME, @pFecha_Hasta DATETIME, @pFlag_Persona_Identificadas TINYINT) 
RETURNS INT
AS
BEGIN

DECLARE @Cant INT

IF(@pFlag_Persona_Identificadas = 1)
BEGIN
	SET @Cant = ISNULL((SELECT COUNT(DISTINCT Id_Cliente)
						FROM CD_ES
						WHERE
						Id_Cliente > 0
						AND Id_Controlador = @pId_Controlador
						AND Resultado = @pResultado
						AND Tipo = @pTipo
						AND Fecha >= @pFecha_Desde
						AND Fecha <= @pFecha_Hasta)
						, 0)
END
ELSE
BEGIN
	SET @Cant = ISNULL((SELECT COUNT(*)
						FROM CD_ES
						WHERE
						Id_Cliente = 0
						AND Id_Controlador = @pId_Controlador
						AND Resultado = @pResultado
						AND Tipo = @pTipo
						AND Fecha >= @pFecha_Desde
						AND Fecha <= @pFecha_Hasta)
						, 0)
END

RETURN ISNULL(@Cant, 0)
END
